package de.bebagoe.jfxcontrols;

import javafx.application.Application;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Scene;
import javafx.scene.control.*;
import javafx.scene.layout.*;
import javafx.stage.Stage;

public class SliderLabelSync extends Application {

    @Override
    public void start(Stage stage) {
        int dist = 10;
        var root = new GridPane();
        root.setPadding(new Insets(dist, dist, dist, dist));

        Slider slider = new Slider(0, 1, 0);
        slider.setShowTickMarks(true);
        slider.setShowTickLabels(true);
        slider.setMajorTickUnit(0.1);
        slider.setMinorTickCount(1);
        slider.setSnapToTicks(true);

        Label label = new Label();
        label.setPrefWidth(50);
        label.setAlignment(Pos.CENTER_RIGHT);

        label.textProperty().bind(slider.valueProperty().asString("%4.2f"));

        root.add(slider, 0, 0);
        root.add(label, 1, 0);

        GridPane.setHgrow(slider, Priority.ALWAYS);
        //root.setGridLinesVisible(true);

        stage.setScene(new Scene(root, 300, 100));
        stage.setTitle("Slider-Label-Sync");
        stage.show();
    }

    public static void main(String[] args) {
        launch(args);
    }
}
